% This function assigns the contribution of each sample classes (two classes: 1&2) 
% to the different clusters. For example: in cluster k=1, how many  pixels of
% class =1 and pixels of class=2 are retained in that cluster.

function [class1_to_component, class2_to_component] = assign_survivalClassesToClusters(sample_data, goodlist, region_overview,sample_to_component)
N = length(sample_to_component);
S = size(region_overview);
indx = find(goodlist>0);
Clusters_class1 = [];
Clusters_class2 = [];
for i= 1:N
    sampleID = sample_to_component(i,1);
    AssignedCluster = sample_to_component(i,2);
    Status = sample_data.pN(sampleID);
    if (Status == 1)        
        Clusters_class1 = [Clusters_class1; AssignedCluster];
    else
        Clusters_class2 = [Clusters_class2; AssignedCluster];
    end
end

N_K = length(unique(sample_to_component(:,2)));

for i=1:N_K
    v1 = length(find(Clusters_class1==i));
    v2 = length(find(Clusters_class2==i));
    class1_to_component(i) = v1;
    class2_to_component(i) = v2;
end
